--px_ragdoll_sync.ms is for sync pose info of the max biped system with corresponding physX hulls. 
--Author : Hypark Piao
--Contact : hpiao@nvidia.com
--Copyright (C) 2008-2009 nVIDIA Corp.
--For conditions of distribution and use, see copyright notice in http://www.nvidia.com/PhysX.

--purpose: Call this in simulation step for ragdoll.
--details:   The way is to sync & update user selected Biped model's posture with hulls 
--             &joints representation in PhysX scene by traversing 3dMax Biped system's bone
--             system's hierarchically and assign the  corresponding rotation quaternion info to each bones.
--@param bipObj : the root node of a biped system.
--@return null

function sync_ragdoll bipObj = 
(
	if ( classOf(bipObj)!=Biped_Object )  do
	(
		format( "PhysX Error: the object is not the root of a biped!" )
		false
	)
	else
	(
		--get the pelvis node
		local bipPelvis = biped.getNode bipObj #pelvis
		if bipPelvis!=undefined do
		(	
			modRB = PxGetModRB bipPelvis
			if modRB != undefined do
			(
				if modRB.type == PX_PHYSTYPE_DYNAMIC do
				(
					local mPose = nvpx.GetBonePose bipPelvis
					biped.setTransform bipObj #pos mPose.translationpart true
					
					-- -DH: added these because they seem like they should be here but everything goes crazy instead, 
					-- -so maybe the system respects pelvis rotation and scale but not position
					-- biped.setTransform bipObj #rotation  mPose.rotationpart  false
					-- biped.setTransform bipObj #scale mPose.scalepart   false
				)
			)
		)
		true
	)
)

